/**

 * @license Copyright (c) 2003-2014, CKSource - Frederico Knabben. All rights reserved.

 * For licensing, see LICENSE.html or http://ckeditor.com/license

 */



CKEDITOR.editorConfig = function( config ) {

	// Define changes to default configuration here. For example:

	// config.language = 'fr';

	// config.uiColor = '#AADC6E';

	

	config.height = '300px';

	config.extraPlugins = 'sourcedialog';

	config.allowedContent = true;

	CKEDITOR.config.forcePasteAsPlainText = false;

	config.coreStyles_bold = { element : 'b', overrides : 'strong' };

	CKEDITOR.config.enterMode = CKEDITOR.ENTER_BR;

	config.extraAllowedContent = 'tr[part]';

	

	config.toolbar = [

		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ], items: [ 'Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'RemoveFormat' ] },

		{ name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ], items: [ 'NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl'] },

		{ name: 'links', items: [ 'Link', 'Unlink', 'Anchor' ] },

		{ name: 'insert', items: [ 'Image', 'Flash', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'PageBreak'] },

		

		{ name: 'styles', items: [ 'Styles', 'Format', 'Font', 'FontSize' ] },

		{ name: 'colors', items: [ 'TextColor', 'BGColor' ] },

		{ name: 'tools', items: [ 'Maximize'] },

		{ name: 'others', items: [ 'Source' ] } 

	];



	// Toolbar groups configuration.

	config.toolbarGroups = [

		{ name: 'document', groups: [ 'mode', 'document', 'doctools' ] },

		{ name: 'clipboard', groups: [ 'clipboard', 'undo' ] },

		{ name: 'editing', groups: [ 'find', 'selection', 'spellchecker' ] },

		{ name: 'forms' },

		'/',

		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },

		{ name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ] },

		{ name: 'links' },

		{ name: 'insert' },

		'/',

		{ name: 'styles' },

		{ name: 'colors' },

		{ name: 'tools' },

		{ name: 'others' },

		{ name: 'about' }

	];

};

